<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Order Planning Dashboard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/index.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/style.css">
    <style>
        #preloder {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: inline-block;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }

        .table th, .table td {
            width: 70px !important;
            font-size: 0.65rem;
            padding: 0.4rem !important;
        }
        .progress { height: 10px; background-color: #e9ecef; }
        .bg-purple { background-color: #a855f7 !important; color: #fff; }
        #monthRangePicker { font-size: 0.8rem; padding: 0.25rem 0.5rem; }
        .filter-toggle {
            background: none;
            border: none;
            cursor: pointer;
            padding: 2px;
            font-size: 12px;
            color: #444;
            transition: color 0.2s;
        }
        .filter-toggle:hover, .filter-toggle:focus {
            color: #007bff;
            outline: none;
        }
        .dropdown-filter {
            position: relative;
            display: inline-block;
            margin-left: 6px;
        }
        .checkbox-dropdown-content {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            z-index: 100;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 6px;
            box-shadow: 0 8px 12px rgba(0, 0, 0, 0.08);
            padding: 10px;
            min-width: 180px;
            max-height: 240px;
            overflow-y: auto;
        }
        .dropdown-filter.show .checkbox-dropdown-content {
            display: block;
        }
        .checkbox-dropdown-actions {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
        }
        .checkbox-dropdown-actions button {
            font-size: 12px;
            padding: 3px 8px;
            background-color: #f4f4f4;
            border: 1px solid #ccc;
            border-radius: 4px;
            cursor: pointer;
        }
        .checkbox-dropdown-actions button:hover {
            background-color: #e9e9e9;
        }
        .checkbox-options label {
            display: flex;
            align-items: center;
            margin-bottom: 6px;
            font-size: 12px;
            gap: 6px;
            cursor: pointer;
        }
        .checkbox-options input[type="checkbox"] {
            margin: 0;
            transform: scale(1.1);
        }
        .table-bordered th, .table-bordered td { border: 1px solid #dee2e6; }
        #orderTableBody { font-size: 0.75rem !important; }

        /* Make dropdown filter text black */
        .checkbox-dropdown-content,
        .checkbox-dropdown-content label,
        .checkbox-dropdown-content input,
        .checkbox-dropdown-actions button {
            color: #000 !important;
        }
        .card-body {
            padding: 0rem !important;
        }
        .form-control {
            font-size: 0.8rem !important;
            padding: 0.25rem 0.25rem !important;
        }
        .form-select {
            font-size: 0.8rem !important;
            padding: 0.25rem 0.25rem !important;
        }
    </style>

    <style>
        #DataTables_Table_0_filter {
            display: none !important;
        }
        #DataTables_Table_1_filter {
            display: none !important;
        }
        #DataTables_Table_0, .table th, .table td{
            padding:0.3rem !important;
            
        }
        #DataTables_Table_1, .table th, .table td {
            padding: 0.2rem !important;
        }
        .cap-month-cell {
            cursor: pointer;
        }

    </style>
        <style>
    .progress-bar.bg-purple {
        background-color: #6f42c1;
    }
    .progress-bar.bg-info {
        background-color: #0dcaf0;
    }
    .progress-bar.bg-secondary {
        background-color: #6c757d;
    }

    
</style>
</head>
<body>
     @php
        
        $empl_no = Session::get('empl_id');
        $empl_name = Session::get('emp_name');
    @endphp

    <div class="container-fluid py-3">
                <div class="d-flex justify-content-between align-items-center mb-3 mt-3">
                    <h5 class="fw-bold mb-0">🗓️ Monthly Capacity Overview</h5>
                    <div class="d-flex justify-content-end mb-2">
        <input type="text" id="monthRangePicker" class="form-control w-auto" placeholder="Select Month Range" />
    </div>
                </div>


        <!-- Date Range Filter -->
    
 
    <!-- Table -->
    <div class="">

    @php

    use Carbon\Carbon;
    $months = collect(range(0, 11))->map(fn($i) => Carbon::now()->startOfMonth()->addMonths($i)->format('M-y'))->toArray();
    
    // Group raw data by Unit and Month
    $factories = [];
    foreach ($capdata as $row) {
        $unit = strtoupper($row['Unit']);
        $month = Carbon::parse('1 ' . $row['Ship_Month'])->format('M-y'); // match format with $months  
        $factories[$unit][$month]['month']= $row['Ship_Month'];
        $factories[$unit][$month]['used'] = ($factories[$unit][$month]['used'] ?? 0) + $row['Booked_Mins'];
        $factories[$unit][$month]['avail'] = ($factories[$unit][$month]['avail'] ?? 0) + $row['Unit_Capacity'];
        $factories[$unit][$month]['unit'] = $row['Unit_Code'] ?? 0;
    }
    
    @endphp

    <div class="table-responsive">
        <table id="capacityTable" class="table table-sm table-bordered text-center align-middle">
            <thead class="bg-primary text-white">
                <tr>
                    <th>Factory</th>
                    @foreach($months as $m) <th>{{ $m }}</th> @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach($factories as $factory => $data)
                    <tr>
                        <td class="bg-light fw-bold">{{ $factory }}</td>
                        @foreach($months as $m)
                            @php
                                $used1 = $data[$m]['used'] ?? 0;
                                $avail1 = $data[$m]['avail'] ?? 0;
                                $util = $avail1 > 0 ? round(($used1 / $avail1) * 100, 1) : 0;
                                $color = $util < 75 ? 'danger' : ($util < 90 ? 'warning' : ($util < 120 ? 'success' : 'purple'));
                                $UnitCode = $data[$m]['unit'] ?? 0;
                                $MonthCode = $data[$m]['month'] ?? 0;

                                $used_lakhs = $used1 / 100000;
                                $avail_lakhs = $avail1 / 100000;
                                $used = $used_lakhs == 0 ? '0' : number_format($used_lakhs, 2) . ' L';
                                $avail = $avail_lakhs == 0 ? '0' : number_format($avail_lakhs, 2) . ' L';


                            @endphp
                            <td class="p-2 align-middle cap-month-cell" data-factory="{{$UnitCode}}" data-month="{{$MonthCode}}">
    <div class="fw-semibold small text-dark mb-1">
        {{ $used }} / {{ $avail }} min
    </div>

    <div class="d-flex align-items-center gap-2">
        <div class="progress w-100" style="height: 12px; background-color: #f1f1f1; border-radius: 6px;">
            <div
                class="progress-bar bg-{{ $color }}"
                role="progressbar"
                style="width: {{ $util }}%;"
                aria-valuenow="{{ $util }}"
                aria-valuemin="0"
                aria-valuemax="150"
            >
            </div>
        </div>
        <div style="min-width: 40px; font-size: 0.65rem; font-weight: 600;">
            {{ $util }}%
        </div>
    </div>
</td>

                        @endforeach
                    </tr>
                @endforeach

                {{-- Total Row --}}
                <tr>
                    <td class="bg-light fw-bold">Total</td>
                    @foreach($months as $m)
                        @php
                            $used1 = $avail1 = 0;
                            foreach($factories as $data) {
                                $used1 += $data[$m]['used'] ?? 0;
                                $avail1 += $data[$m]['avail'] ?? 0;
                            }
                            $util = $avail1 > 0 ? round(($used1 / $avail1) * 100, 1) : 0;
                            $color = $util < 75 ? 'danger' : ($util < 90 ? 'warning' : ($util < 120 ? 'success' : 'purple'));
                            $UnitCode = null;
                            $MonthCode = $data[$m]['month'] ?? 0;

                            $used_lakhs = $used1 / 100000;
                            $avail_lakhs = $avail1 / 100000;
                            $used = $used_lakhs == 0 ? '0' : number_format($used_lakhs, 2) . ' L';
                            $avail = $avail_lakhs == 0 ? '0' : number_format($avail_lakhs, 2) . ' L';

                        @endphp
                        <td class="p-2 align-middle cap-month-cell" data-factory="{{$UnitCode}}" data-month="{{$MonthCode}}">
    <div class="fw-semibold small text-dark mb-1">
        {{ ($used) }} / {{ ($avail) }} min
    </div>

    <div class="d-flex align-items-center gap-2">
        <div class="progress w-100" style="height: 12px; background-color: #f1f1f1; border-radius: 6px;">
            <div
                class="progress-bar bg-{{ $color }}"
                role="progressbar"
                style="width: {{ $util }}%;"
                aria-valuenow="{{ $util }}"
                aria-valuemin="0"
                aria-valuemax="150"
            >
            </div>
        </div>
        <div style="min-width: 40px; font-size: 0.65rem; font-weight: 600;">
            {{ $util }}%
        </div>
    </div>
</td>

                    @endforeach
                </tr>
            </tbody>
        </table>
    </div>

    
    
    
    <!-- <div id="preloder">
        <div class="lds-hourglass">

        </div>
    </div>  -->
                        


    </div>
       
                <div class="d-flex justify-content-between align-items-center mb-3 mt-3">
                    <h5 class="fw-bold mb-0"> Order Planning Dashboard</h5>
                    <div class="form-check form-switch">
                        <input type="checkbox" id="aggregatedView" class="form-check-input">
                        <label class="form-check-label" for="aggregatedView">Aggregated View</label>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle" id="orderTable">
                        <thead class="table-secondary text-white text-center" id="orderTableHeader">
                            <tr>
                                <th>
                                    Buyer
                                    <div class="dropdown-filter" data-column="0">
                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                </th>
                                <th>
                                    OCN
                                    <div class="dropdown-filter" data-column="1">
                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                </th>
                                <th class="col-color">
                                    Color
                                    <div class="dropdown-filter" data-column="2">
                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                </th>
                                <th class="col-item">
                                    Item
                                    <div class="dropdown-filter" data-column="3">
                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                </th>
                                <th>SAM</th>
                                <th>Bal. to sew</th>
                                <th>Value ($)</th>
                                <th>Booked Min.</th>
                                <th>
                                    Factory Exit Date
                                    <div class="dropdown-filter" data-column="8">
                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                        <div class="checkbox-dropdown-content">
                                            <input type="text" class="form-control date-range-filter" id="factoryExitDateRange" placeholder="Select range" autocomplete="off" style="margin-bottom:8px;" />
                                            <button class="clear-date-range btn btn-sm btn-light w-100">Clear</button>
                                        </div>
                                    </div>
                                </th>
                                <th>
                                    Shipping Date
                                    <div class="dropdown-filter" data-column="9">
                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                        <div class="checkbox-dropdown-content">
                                            <input type="text" class="form-control date-range-filter" id="shippingDateRange" placeholder="Select range" autocomplete="off" style="margin-bottom:8px;" />
                                            <button class="clear-date-range btn btn-sm btn-light w-100">Clear</button>
                                        </div>
                                    </div>
                                </th>
                                <th>Unit</th>
                                <th>
                                    Status
                                    <div class="dropdown-filter" data-column="11">
                                        <button class="filter-toggle" title="Filter this column">🔽</button>
                                        <div class="checkbox-dropdown-content">
                                            <div class="checkbox-dropdown-actions">
                                                <button class="select-all">Select All</button>
                                                <button class="clear-all">Clear</button>
                                            </div>
                                            <div class="checkbox-options"></div>
                                        </div>
                                    </div>
                                </th>
                            </tr>
                        </thead>
                        <tbody id="orderTableBody"></tbody>
                    </table>
                </div>
        
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script>
        let unitOptions = [];
        let table;
        let originalPlanData = [];

        function formatDate(dateStr) {
            if (!dateStr) return "";
            const d = new Date(dateStr);
            return d.toLocaleDateString("en-GB").replace(/\/\d{4}$/, match => "/" + String(d.getFullYear()).slice(-2));
        }

        function formatSortableDate(dateStr) {
            // Expects dd/mm/yy or dd/mm/yyyy
            if (!dateStr) return '';
            const parts = dateStr.split('/');
            if (parts.length !== 3) return '';
            let [d, m, y] = parts;
            d = d.padStart(2, '0');
            m = m.padStart(2, '0');
            y = y.length === 2 ? '20' + y : y;
            return `${y}-${m}-${d}`;
        }

        function buildRow(row, units) {
            const shipDate = formatDate(row.Ship_Date);
            const shipDateSortable = row.Ship_Date ? new Date(row.Ship_Date).toISOString().slice(0,10) : '';
            const exitDateSortable = row.exit_date ? formatSortableDate(row.exit_date) : '';

            
            let selectedUnit = row.unit || "";
            // Treat "null", "NULL", undefined, null, or empty as no unit
            if (
                !selectedUnit ||
                selectedUnit === "null" ||
                selectedUnit === "NULL" ||
                selectedUnit.trim() === ""
            ) {
                selectedUnit = "";
            }

            const unitSelect = `
                <select class="form-select unit-select" data-itemid="${row.Itemid || ''}" data-colorid="${row.Colorid || ''}">
                    <option value="" disabled ${!selectedUnit ? "selected" : ""}>Unit</option>
                    ${units.map(unit => `
                        <option value="${unit}"${selectedUnit === unit ? " selected" : ""}>${unit}</option>
                    `).join("")}
                </select>
            `;

           

            
            let statusText = row.status || "";
            let statusColor = "";
            if (statusText === "On Time") statusColor = "green";
            else if (statusText === "Pre poned") statusColor = "blue";
            else if (statusText === "Post pond") statusColor = "red";
            


          

            return `
                <tr>
                    <td>${row.Buyer || ""}</td>
                    <td>${row.OCN || ""}</td>
                    <td class="col-color">${row.Color || ""}</td>
                    <td class="col-item">${row.Item || ""}</td>
                    <td>${row.SAM || ""}</td>
                    <td>${row.Bal_To_Sew || ""}</td>
                    <td>${row.Value || ""}</td>
                    <td>${row.Booked_Mins || ""}</td>
                    <td>
                        <span style="display:none">${exitDateSortable}</span>
                        <input 
                            type="text" 
                            class="form-control factory-exit-date" 
                            placeholder="Select date"
                            value="${row.exit_date ? row.exit_date : ''}"
                            data-itemid="${row.Itemid || ''}"
                            data-colorid="${row.Colorid || ''}"
                            data-empid="${window.emp_id || ''}"
                            data-shipdate="${shipDate}"
                            data-ocn="${row.OCN || ''}"
                            data-prev-exit="${row.pre_exit || ''}"
                        />
                    </td>
                    <td>
                        <span style="display:none">${shipDateSortable}</span>
                        ${shipDate}
                    </td>
                    <td>${unitSelect}</td>
                    <td style="color:${statusColor}">${statusText}</td>
                </tr>`;
        }

         function renderTable(data, isAggregated, units) {
                if (!Array.isArray(data)) {
                    console.error("renderTable() called with invalid data:", data);
                    return;
                }
                if (!units || !Array.isArray(units)) return;

                const tbody = document.getElementById("orderTableBody");
                tbody.innerHTML = "";

            console.log("data:", data);

            console.log("units:", units);
            if (isAggregated) {
                // Step 1: Add cleaned OCNKey to each row (last 5 digits or full if not present)
                data.forEach(row => {
                    const match =row.OCN?.match(/\d+$/);
                    console.log("OCN:", row.OCN);
                    row.OCNKey = match ? match[0] : (row.OCN || "Unknown");
                });

                // Step 2: Group by OCNKey
                const groupedData = data.reduce((acc, row) => {
                    const ocn = row.OCNKey;
                    if (!acc[ocn]) {
                        acc[ocn] = {
                            ...row,
                            OCN: ocn, // display cleaned OCN
                            Bal_To_Sew: 0,
                            Booked_Mins: 0,
                            Value: 0,
                            SAM: 0,
                            count: 0
                        };
                    }
                    acc[ocn].Bal_To_Sew += parseFloat(row.Bal_To_Sew || 0);
                    acc[ocn].Booked_Mins += parseFloat(row.Booked_Mins || 0);
                    acc[ocn].Value += parseFloat(row.Value || 0);
                    acc[ocn].SAM += parseFloat(row.SAM || 0);
                    acc[ocn].count += 1;
                    return acc;
                }, {});

                const groupedResult = Object.values(groupedData);

                // Step 3: Render aggregated rows
                groupedResult.forEach(row => {
                    const shipDate = formatDate(row.Ship_Date);
                    
                    const unitSelect = `<select class="form-select unit-select" data-itemid="${row.Itemid}" data-colorid="${row.Colorid}">
                        ${units.map(u => `<option ${u === row.Unit_Alloc ? "selected" : ""}>${u}</option>`).join("")}
                    </select>`;

                    tbody.innerHTML += `
                        <tr>
                            <td>${row.Buyer}</td>
                            <td>${row.OCN}</td>
                            <td class="col-color d-none"></td>
                            <td class="col-item d-none"></td>
                            <td>${parseFloat(row.SAM).toFixed(2)}</td>
                            <td>${row.Bal_To_Sew}</td>
                            <td>${row.Value.toFixed(2)}</td>
                            <td>${row.Booked_Mins}</td>
                            <td>
                                <input type="text" class="form-control factory-exit-date"
                                    data-itemid="${row.Itemid}" data-colorid="${row.Colorid}"
                                    data-empid="${window.emp_id}" data-shipdate="${shipDate}"
                                    data-ocn="${row.OCN}" data-prev-exit="" placeholder="Select date"/>
                            </td>
                            <td>${shipDate}</td>
                            <td>${unitSelect}</td>
                            <td class="status-cell"></td>
                        </tr>`;
                });

            } else {
                // Detailed view
                data.forEach(row => {
                    tbody.innerHTML += buildRow(row, units);
                });
            }

            flatpickr(".factory-exit-date", { dateFormat: "d/m/y", minDate: "today" });
        }

        $.fn.dataTable.ext.order['dom-hidden-span'] = function(settings, col) {
            return this.api().column(col, {order:'index'}).nodes().map(function(td, i) {
                return $('span', td).text();
            });
        };



        function populateDropdownFilters(data, isAggregated) {
            const columnMap = {
                0: "Buyer",
                1: "OCN",
                2: "Color",
                3: "Item",
                11: "status"
            };
            

            Object.entries(columnMap).forEach(([colIdx, prop]) => {
                let uniqueValues = [...new Set(data.map(row => {
                    if (colIdx == 1 && row[prop]) {
                        return row[prop].match(/\d{5}$/) ? row[prop].match(/\d{5}$/)[0] : row[prop];
                    }
                    return row[prop] || "";
                }))].filter(v => v !== "");
                // if (isAggregated && (colIdx == 2 || colIdx == 3)) {
                //     uniqueValues = [];
                // }
                // Set checked="" to nothing (unchecked)
                const optionsHtml = uniqueValues.sort().map(val =>
                    `<label><input type="checkbox" class="col-filter" value="${val}"> ${val}</label>`
                ).join("");
                $(`.dropdown-filter[data-column="${colIdx}"] .checkbox-options`).html(optionsHtml);
            });
        }

        flatpickr("#factoryExitDateRange", {
            mode: "range",
            dateFormat: "d/m/y",
            allowInput: true
        });
        flatpickr("#shippingDateRange", {
            mode: "range",
            dateFormat: "d/m/y",
            allowInput: true
        });

        function loadUnits() {
            return $.get('{{ env("API_URL") }}productionunitdetails')
                .then(res => res.data.map(u => u.Unit_Short_Name))
                .catch(() => ["G-I", "Unit A", "Unit B"]);
        }

        function saveExitStatusToDB({ exit_date, ship_date, status, item_id, color_id, pre_exit, emp_id, OCN, unit }) {
            $.ajax({
                url: '/plandataupdate',
                method: 'POST',
                data: {
                    exit_date: exit_date,
                    ship_date: ship_date,
                    status: status,
                    item_id: item_id,
                    color_id: color_id,
                    pre_exit: pre_exit,
                    emp_id: emp_id,
                    ocn_no: OCN,
                    unit: unit,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    console.log('Saved successfully', response);
                },
                error: function(xhr, status, error) {
                    console.error('Save failed', error);
                    alert('Failed to save data. Please try again.');
                }
            });
        }

        function parseDate(dateStr) {
            const [day, month, year] = dateStr.split("/").map(Number);
            return new Date(2000 + (year < 100 ? year : year % 100), month - 1, day);
        }

        function isDateInRange(dateStr, startDateStr, endDateStr) {
            const date = parseDate(dateStr);
            const startDate = parseDate(startDateStr);
            const endDate = parseDate(endDateStr);
            return date >= startDate && date <= endDate;
        }

        function fetchPlanData() {
            loadUnits().then(function(units) {
                window.unitOptions = units;
                console.log("Units loaded:", units);
                $.ajax({
                    // url: "http://172.16.10.169:8896/api/plandata",
                    url: "{{ route('macroplandata') }}",
                    method: "GET",
                    success: function(response) {
                        originalPlanData = response.data.plandata || [];
                        window.originalPlanData=originalPlanData;
                        console.log(response.data.unit);
                        renderTable(originalPlanData, $('#aggregatedView').is(':checked'), units);
                
                        populateDropdownFilters(originalPlanData, $('#aggregatedView').is(':checked'));

                        applyFilters();

                        table = $('#orderTableBody').closest('table').DataTable({
                            paging: false,
                            searching: false,
                            ordering: true,
                            columnDefs: [
                                {
                                    targets: [8, 9], // Factory Exit Date and Shipping Date
                                    orderDataType: 'dom-hidden-span'
                                }
                            ]
                        });

                        flatpickr("#factoryExitDateFilter", {
                            mode: "range",
                            dateFormat: "d/m/y",
                            allowinput: true,
                            minDate: "today",
                            onChange: function() {
                                if (table) table.draw();
                            }
                        });

                        console.log("Units loaded2:", units);

                        $.fn.dataTable.ext.search = [];
                        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                            let visible = true;

                            $('.dropdown-filter').each(function() {
                                const colIdx = $(this).data('column');
                                const selected = $(this).find('input.col-filter:checked').map(function() {
                                    return this.value;
                                }).get();
                                let cellValue = data[colIdx];

                                if (colIdx == 1 && cellValue) {
                                    const match = cellValue.match(/\d{5}$/);
                                    cellValue = match ? match[0] : cellValue;
                                }

                                if ($('#aggregatedView').is(':checked') && (colIdx == 2 || colIdx == 3)) {
                                    return;
                                }

                                if (selected.length && !selected.includes(cellValue)) {
                                    visible = false;
                                }
                            });

                            const factoryExitDate = data[8];
                            const factoryExitDateFilter = $('#factoryExitDateFilter').val();
                            if (factoryExitDateFilter) {
                                const [startDate, endDate] = factoryExitDateFilter.split(" to ");
                                if (startDate && endDate && factoryExitDate) {
                                    if (!isDateInRange(factoryExitDate, startDate, endDate)) {
                                        visible = false;
                                    }
                                }
                            }

                            return visible;
                        });

                        $(document).off('change', '.factory-exit-date').on('change', '.factory-exit-date', function() {
                            const row = $(this).closest('tr')[0];
                            const shipDateCell = row.children[9];
                            const statusCell = row.children[11];
                            const factoryDateStr = this.value;
                            const shipDateStr = shipDateCell.textContent.trim();

                            const pre_exit = this.dataset.prevExit || "";
                            const item_id = this.dataset.itemid;
                            const color_id = this.dataset.colorid;
                            const emp_id = this.dataset.empid;
                            const OCN = this.dataset.ocn || '';
                            const unit = row.querySelector('.unit-select') ? row.querySelector('.unit-select').value : '';

                            if (factoryDateStr && shipDateStr) {
                                // Calculate statusText and statusColor
                                const [fd, fm, fy] = factoryDateStr.split('/').map(Number);
                                const [sd, sm, sy] = shipDateStr.split('/').map(Number);
                                const factoryDate = new Date(2000 + (fy < 100 ? fy : fy % 100), fm - 1, fd);
                                const shipDate = new Date(2000 + (sy < 100 ? sy : sy % 100), sm - 1, sd);

                                const diffDays = Math.round((shipDate - factoryDate) / (1000 * 60 * 60 * 24));
                                let statusText = '';
                                let statusColor = '';

                                if (diffDays === 7) {
                                    statusText = 'On Time';
                                    statusColor = 'green';
                                } else if (diffDays > 7) {
                                    statusText = 'Preponed';
                                    statusColor = 'blue';
                                } else {
                                    statusText = 'Postponed';
                                    statusColor = 'red';
                                }

                                statusCell.textContent = statusText;
                                statusCell.style.color = statusColor;

                                // Use different AJAX for aggregated view
                                if ($('#aggregatedView').is(':checked')) {
                                    saveAggregateOCNToDB({
                                        exit_date: factoryDateStr,
                                        ship_date: shipDateStr,
                                        status: statusText,
                                        item_id: item_id,
                                        color_id: color_id,
                                        pre_exit: pre_exit,
                                        emp_id: emp_id,
                                        OCN: OCN,
                                        unit: unit
                                    });
                                } else {
                                    saveExitStatusToDB({
                                        exit_date: factoryDateStr,
                                        ship_date: shipDateStr,
                                        status: statusText,
                                        item_id: item_id,
                                        color_id: color_id,
                                        pre_exit: pre_exit,
                                        emp_id: emp_id,
                                        OCN: OCN,
                                        unit: unit
                                    });
                                }

                                this.dataset.prevExit = factoryDateStr;
                            }
                        });

                        $(document).off('change', '.unit-select').on('change', '.unit-select', function() {
                            const row = $(this).closest('tr')[0];
                            const factoryExitInput = row.querySelector('.factory-exit-date');
                            const statusCell = row.children[11];
                            const item_id = this.dataset.itemid;
                            const color_id = this.dataset.colorid;
                            const emp_id = window.emp_id || '';
                            const OCN = factoryExitInput ? factoryExitInput.dataset.ocn : '';
                            const exit_date = factoryExitInput ? factoryExitInput.value : '';
                            const ship_date = row.children[9].textContent.trim();
                            const status = statusCell.textContent.trim();
                            const unit = this.value;

                            if (exit_date) {
                                if ($('#aggregatedView').is(':checked')) {
                                    saveAggregateOCNToDB({
                                        exit_date: exit_date,
                                        ship_date: ship_date,
                                        status: status,
                                        item_id: item_id,
                                        color_id: color_id,
                                        pre_exit: "",
                                        emp_id: emp_id,
                                        OCN: OCN,
                                        unit: unit
                                    });
                                } else {
                                    saveExitStatusToDB({
                                        exit_date: exit_date,
                                        ship_date: ship_date,
                                        status: status,
                                        item_id: item_id,
                                        color_id: color_id,
                                        pre_exit: "",
                                        emp_id: emp_id,
                                        OCN: OCN,
                                        unit: unit
                                    });
                                }
                            } else {
                                alert("Please select Factory Exit Date first to create the record before updating unit.");
                            }
                        });

                        $('.filter-toggle').off('click').on('click', function(e) {
                            e.stopPropagation();
                            $('.dropdown-filter').not($(this).parent()).removeClass('show');
                            $(this).parent().toggleClass('show');
                        });

                        $(document).off('click.dropdownfilter').on('click.dropdownfilter', function() {
                            $('.dropdown-filter').removeClass('show');
                        });

                        $('.select-all').off('click').on('click', function(e) {
                            e.stopPropagation();
                            const dropdown = $(this).closest('.dropdown-filter');
                            dropdown.find('input.col-filter').prop('checked', true);
                            applyFilters();
                        });

                        $('.clear-all').off('click').on('click', function(e) {
                            e.stopPropagation();
                            const dropdown = $(this).closest('.dropdown-filter');
                            dropdown.find('input.col-filter').prop('checked', false);
                            applyFilters();
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Failed to fetch plan data:', error);
                        alert('Failed to load plan data. Using fallback unit options.');
                        renderTable(originalPlanData, $('#aggregatedView').is(':checked'), units);
                        populateDropdownFilters(originalPlanData, $('#aggregatedView').is(':checked'));
                    }
                });
            });
        }

        flatpickr("#monthRangePicker", {
            mode: "range",
            dateFormat: "M Y",
            plugins: [
                new monthSelectPlugin({
                    shorthand: true,
                    dateFormat: "M Y",
                    altFormat: "F Y"
                })
            ],
            onChange: function(selectedDates, dateStr, instance) {
                if (selectedDates.length === 1) {
                    // User picked a month, auto-select next 11 months
                    const start = selectedDates[0];
                    const end = new Date(start.getFullYear(), start.getMonth() + 11, 1);
                    instance.setDate([start, end], true);
                }
                // You can add your logic here to use the selected range
                // Example: console.log("Selected range:", instance.selectedDates);
            }
        });

        $("#aggregatedView").on("change", function () {
            const isChecked = $(this).is(":checked");
            $(".col-color, .col-item").toggle(!isChecked);
            $(".table thead .col-color, .table thead .col-item").toggle(!isChecked);
            renderTable(window.originalPlanData, isChecked, window.unitOptions);
            populateDropdownFilters(window.originalPlanData, isChecked);
        });

        $(document).ready(function() {
            window.emp_id = "{{ $empl_no }}";
            fetchPlanData();
        });



        function applyFilters() {
           
            const filters = {};
            $('.dropdown-filter').each(function () {
                const colIdx = $(this).data('column');
                filters[colIdx] = $(this).find('input:checked').map(function () {
                    return this.value;
                }).get();
            });

            // Get date ranges
            const factoryExitRange = $('#factoryExitDateRange').val().split(' to ');
            const shippingDateRange = $('#shippingDateRange').val().split(' to ');

                    if ((!factoryExitRange[0] || !factoryExitRange[1]) && (!shippingDateRange[0] || !shippingDateRange[1])) {
                        $('#orderTableBody tr').show();
                        return;
                    }

          function parseDate(dateStr) {
                if (!dateStr.includes('/')) return null;
                const parts = dateStr.split('/');
                if (parts.length !== 3) return null;
                let [d, m, y] = parts.map(p => p.trim());
                if (!d || !m || !y) return null;
                if (y.length === 2) y = '20' + y;
                return new Date(`${y}-${m.padStart(2, '0')}-${d.padStart(2, '0')}`);
            }

            $('#orderTableBody tr').each(function () {
                let show = true;

                $(this).find('td').each(function (i) {
                    const $cell = $(this);

                    // Column filter
                    if (Array.isArray(filters[i]) && filters[i].length) {
                        let cellValue = $cell.text().trim();

                        // Special logic for OCN column (index 1)
                        if (i === 1 && cellValue) {
                            const match = cellValue.match(/\d{5}$/);
                            cellValue = match ? match[0] : cellValue;
                        }

                        if (!filters[i].includes(cellValue)) {
                            show = false;
                            return false; // break loop
                        }
                    }

                    // Factory Exit Date filter (index 8)
                    if (i === 8 && factoryExitRange[0] && factoryExitRange[1]) {
                        let dateVal = $cell.find('input').val() || $cell.text().trim();
                        const cellDate = parseDate(dateVal);
                        const startDate = parseDate(factoryExitRange[0]);
                        const endDate = parseDate(factoryExitRange[1]);

                        if (!cellDate || !startDate || !endDate || cellDate < startDate || cellDate > endDate) {
                            show = false;
                            return false;
                        }
                    }

                    // Shipping Date filter (index 9)
                    if (i === 9 && shippingDateRange[0] && shippingDateRange[1]) {
                        let dateVal = $cell.text().trim();
                        const cellDate = parseDate(dateVal);
                        const startDate = new Date(shippingDateRange[0]);
                        const endDate = new Date(shippingDateRange[1]);

                        if (!cellDate || cellDate < startDate || cellDate > endDate) {
                            show = false;
                            return false;
                        }
                    }
                });

                $(this).toggle(show);
            });

        }

        $(document).on('click', '.clear-date-range', function(e) {
            e.stopPropagation();
            $(this).siblings('input.date-range-filter').val('');
            applyFilters();
        });

        $('#factoryExitDateRange, #shippingDateRange').on('change', applyFilters);

        $(document).on('change', '.col-filter', applyFilters);
        $('.select-all').on('click', function (e) {
            e.stopPropagation();
            const dropdown = $(this).closest('.dropdown-filter');
            dropdown.find('input[type="checkbox"]').prop('checked', true);
            applyFilters();
        });
        $('.clear-all').on('click', function (e) {
            e.stopPropagation();
            const dropdown = $(this).closest('.dropdown-filter');
            dropdown.find('input[type="checkbox"]').prop('checked', false);
            applyFilters();
        });

    function saveAggregateOCNToDB({ exit_date, ship_date, status, item_id, color_id, pre_exit, emp_id, OCN, unit }) {
        $.ajax({
            url: '/aggregateocn',
            method: 'POST',
            data: {
                exit_date: exit_date,
                ship_date: ship_date,
                status: status,
                item_id: item_id,
                color_id: color_id,
                pre_exit: pre_exit,
                emp_id: emp_id,
                ocn_no: OCN,
                unit: unit,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                console.log('Aggregated OCN saved successfully', response);
            },
            error: function(xhr, status, error) {
                console.error('Aggregated OCN save failed', error);
                alert('Failed to save aggregated OCN data. Please try again.');
            }
        });
    }

    applyFilters();
    </script>

    <script>
        $(document).on('click', '.cap-month-cell', function() {
            const month = $(this).data('month');
            const factory = $(this).data('factory');
            alert(month + ' ' + factory + ' clicked');
            $.ajax({
                    url: "http://172.16.10.169:8896/api/plandata",
                    method: "GET",
                    data:{month:month,unit:factory},
                    success: function(response) {
                        console.log(response);
                    },
                    error: function(xhr, status, error) {
                        console.error('Failed to fetch plan data:', error);
                        alert('Failed to load plan data. Using fallback unit options.');
                        renderTable(originalPlanData, $('#aggregatedView').is(':checked'), unitOptions);
                    }
                });
        });
    </script>
</body>
</html>








